import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/domain/models/data/stories_data.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class StoriesItem extends StatelessWidget {
  final StoriesData stories;
  final VoidCallback onEdit;
  final VoidCallback onDelete;
  final int spacing;

  const StoriesItem({
    super.key,
    required this.stories,
    required this.onEdit,
    this.spacing = 1,
    required this.onDelete,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(12.r),
      ),
      margin: EdgeInsets.only(bottom: spacing.r),
      padding: REdgeInsets.symmetric(vertical: 12),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          Row(
            children: [
              12.horizontalSpace,
              CommonImage(
                width: 44,
                height: 48,
                url: (stories.fileUrls?.isNotEmpty ?? false)
                    ? stories.fileUrls?.first
                    : null,
                errorRadius: 0,
                fit: BoxFit.cover,
              ),
              8.horizontalSpace,
              Expanded(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Flexible(
                      child: Text(
                        stories.model?.translation?.title ?? '',
                        style: Style.interRegular(
                          size: 14,
                          color: Style.black,
                          letterSpacing: -0.3,
                        ),
                        maxLines: 2,
                      ),
                    ),
                    8.horizontalSpace,
                    if(DateTime.now().difference(stories.createdAt ?? DateTime.now()).inDays != 0 )
                    Text(
                      "(${AppHelpers.getTranslation(TrKeys.expired)})",
                      style: Style.interRegular(
                        size: 12,
                        color: Style.red,
                        letterSpacing: -0.3,
                      ),
                    ),
                  ],
                ),
              ),
              Row(
                mainAxisSize: MainAxisSize.min,
                children: [
                  8.horizontalSpace,
                  CircleButton(onTap: onEdit, icon: Remix.pencil_line),
                  8.horizontalSpace,
                  CircleButton(onTap: onDelete, icon: Remix.delete_bin_line),
                  8.horizontalSpace,
                ],
              ),
              12.horizontalSpace,
            ],
          ),
        ],
      ),
    );
  }
}
